/*
 * kernel/main.c
 */

#include <kernel/arch/init.h>
#include <kernel/mm.h>
#include <kernel/process.h>
#include <kernel/arch/vid.h>
#include <kernel/arch/int.h>
#include <version.h>

void init_process();
void idle_process();

int kernel_main()
{
	arch_init();
	mm_init();
	process_init();

	vid_puts("\nspeck/" SPECK_ARCH " version " SPECK_VERSION "\n");
	vid_puts("  Built " SPECK_BUILD_DATE " by " SPECK_BUILD_USER "@"
		SPECK_BUILD_HOST "\n");

	vid_puts("\nDone initializing.\n");

	// TODO: one idle process per processor
	process_create((int)idle_process,0,0,1);

	// enable interrupts
	int_enable(INT_ENABLE_FLAGS_INIT);

	while(1);
}

void idle_process()
{
	while(1);
}

//-----------------TESTING CODE------------------

#include <kernel/msg.h>
#include <kernel/irqmsg.h>
#include <kernel/i386/io.h>

void init_process()
{
	pid_t sender;
	int type;
	char buf[1];
	int buflen;
	int timercount = 5;

	vid_puts("Initial process started\n");

	irqmsg_register(IRQMSG_IRQ(0) | IRQMSG_IRQ(1));

	inb(0x60);

	while(1)
	{
		buflen = 1;
		type = msg_recv(&sender,buf,&buflen);
		if(type == MSG_TYPE_IPC)
			continue;

		if(sender == 1)
			inb(0x60); // keep the kbd happy by emptying buffer

		if(sender == 0)
			if(timercount-- <= 0)
				irqmsg_register(IRQMSG_IRQ(1));

		vid_puts("IRQ ");
		vid_putd(sender);
		vid_putc('\n');
	}

	while(1); // DON'T RETURN
}
